using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using NDI.SLIKDA.Interop;

namespace CSWindowsService
{
	/// <summary>
	/// Summary description for ServerForm.
	/// </summary>
	public class ServerForm : System.Windows.Forms.Form
    {
        private SLIKServer slikServer1;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ServerForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		// Get access to the SLIK-DA control
		public SLIKServer SLIKObject
		{
			get
			{
				return slikServer1;
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		[STAThread]
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(ServerForm));
            this.slikServer1 = new NDI.SLIKDA.Interop.SLIKServer();
            ((System.ComponentModel.ISupportInitialize)(this.slikServer1)).BeginInit();
            this.SuspendLayout();
            // 
            // slikServer1
            // 
            this.slikServer1.Enabled = true;
            this.slikServer1.Location = new System.Drawing.Point(93, 48);
            this.slikServer1.Name = "slikServer1";
            this.slikServer1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("slikServer1.OcxState")));
            this.slikServer1.Size = new System.Drawing.Size(32, 32);
            this.slikServer1.TabIndex = 0;
            this.slikServer1.OnWrite += new NDI.SLIKDA.Interop.SLIKServer.OnWriteEventHandler(this.slikServer1_OnWrite);
            this.slikServer1.OnClientConnect += new NDI.SLIKDA.Interop.SLIKServer.OnClientConnectEventHandler(this.slikServer1_OnClientConnect);
            this.slikServer1.OnRead += new NDI.SLIKDA.Interop.SLIKServer.OnReadEventHandler(this.slikServer1_OnRead);
            // 
            // ServerForm
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(208, 125);
            this.Controls.Add(this.slikServer1);
            this.Enabled = false;
            this.Name = "ServerForm";
            this.ShowInTaskbar = false;
            this.Text = "ServerForm";
            this.Load += new System.EventHandler(this.ServerForm_Load);
            ((System.ComponentModel.ISupportInitialize)(this.slikServer1)).EndInit();
            this.ResumeLayout(false);

		}
		#endregion

		private void ServerForm_Load(object sender, System.EventArgs e)
		{
			Visible = false;
		}

		private void slikServer1_OnClientConnect
		(
			object sender, 
			NDI.SLIKDA.Interop.SLIKServer.OnClientConnectEventArgs eventArgs
		)
		{
			eventArgs.AcceptConnection = true;
		}

		private void slikServer1_OnRead
		(
			object sender, 
			NDI.SLIKDA.Interop.SLIKServer.OnReadEventArgs eventArgs
		)
		{
			//
			//	A real server might have to read one or more devices here to service the
			//	Read request.  This server does not communicate with any hardware.  
			//	Instead, we rely on the periodic tag update to simulate data changes, so
			//	this Read call will be basically a no-op.
			//
	    
			// Update the tag level error codes.
			for ( int i = 0; i < eventArgs.Count; i++ )
			{
				// For this server, Tag reads always succeed!
				eventArgs.Errors[i] = (int) OPCDAErrorsEnum.sdaSOK;
			}    
	    
			// Return overall status.  For this server, the overall Read status is
			// always sdaSOK.  A real server should set this according to the tag level
			// read results.
			eventArgs.Result = (int) OPCDAErrorsEnum.sdaSOK;
		}

		private void slikServer1_OnWrite
		(
			object sender, 
			NDI.SLIKDA.Interop.SLIKServer.OnWriteEventArgs eventArgs
		)
		{
			// This simulation server does not talk to any hardware, so we just proceed to
			// write the new values provided to the corresponding Tag.  A real server may
			// validate the data first (e.g. range checking), scale the data, etc. before
			// performing the actual write to the underlying system/hardware.

			short Quality = (short) QualityStatusEnum.sdaGood;
			System.DateTime Timestamp = DefaultValues.SetVQT_Timestamp;

			// Initialize the result code.
			int Result = (int) OPCDAErrorsEnum.sdaSOK;

			// Write each tag
			for( int i = 0; i < eventArgs.Count; i++ )
			{
				try
				{
					object Val;
					// Handle the special case of VT_CY values
					if( eventArgs.Values[i].GetType() == typeof( System.Decimal ) )
						Val = new CurrencyWrapper( eventArgs.Values[i] );
					else
						Val = eventArgs.Values[i];

					eventArgs.Tags[i].SetVQT( 
						Val,
						Quality, 
						Timestamp
						);
					eventArgs.Errors[i] = (int) OPCDAErrorsEnum.sdaSOK;
				}
				catch( System.Exception )
				{
					eventArgs.Errors[i] = (int) OPCDAErrorsEnum.sdaEFail;
					// Must return this result code if any tag level failures 
					Result = (int) OPCDAErrorsEnum.sdaSFalse;
				}
			}
			eventArgs.Result = Result;
		}
	}
}
